/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage;

import com.gizmo.luggage.Registries;
import com.gizmo.luggage.client.LuggageItemRenderer;
import com.gizmo.luggage.entity.LuggageEntity;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.IItemRenderProperties;

public class LuggageItem
extends Item {
    public LuggageItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        BlockHitResult result = LuggageItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            Vec3 blockPos = result.m_82450_();
            if (!level.m_5776_()) {
                LuggageEntity luggage = (LuggageEntity)((EntityType)Registries.EntityRegistry.LUGGAGE.get()).m_20615_(level);
                if (luggage != null) {
                    luggage.m_20219_(blockPos);
                    luggage.tame(player);
                    luggage.restoreFromStack(player.m_21120_(hand));
                    level.m_7967_((Entity)luggage);
                }
                if (!player.m_150110_().f_35937_) {
                    player.m_21120_(hand).m_41774_(1);
                }
            }
            return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    public boolean m_142095_() {
        return false;
    }

    public static Stream<ItemStack> getContentsForToolTip(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        if (compoundtag == null) {
            return Stream.empty();
        }
        ListTag listtag = compoundtag.m_128437_("Inventory", 10);
        return listtag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        LuggageItem.getContentsForToolTip(stack).forEach(arg_0 -> nonnulllist.add(arg_0));
        return nonnulllist.isEmpty() ? Optional.empty() : Optional.of(new Tooltip((NonNullList<ItemStack>)nonnulllist, stack));
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> stacks) {
        super.m_6787_(tab, stacks);
        if (this.m_41389_(tab)) {
            ItemStack item = new ItemStack((ItemLike)this);
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("Extended", true);
            item.m_41751_(tag);
            stacks.add((Object)item);
        }
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return new LuggageItemRenderer();
            }
        });
    }

    public record Tooltip(NonNullList<ItemStack> stacks, ItemStack stack) implements TooltipComponent
    {
    }
}

